;
; idt.asm
;
; By Ross Ridge
; Public Domain
;
; IDT table and handlers for MyJEMM
;

	.386p
	
	.XLIST
	include	vmm.inc
	.LIST

_IDATA	SEGMENT
	DB	"@(#) vjemm idt.asm 1.3 03/06/09 18:48:43", 0
_IDATA	ENDS

	; EXTRN	_handle_fault:PROC
	; EXTRN	_handle_swint:PROC
	; EXTRN	_handle_io:PROC
	EXTRN	_handle_idt:PROC
	EXTRN	_saved_vmm_idt:DWORD
	IFDEF	USE_LOG
	EXTRN	_logframe:PROC
	EXTRN	_lognote:PROC
	EXTRN	_lognum:PROC
	EXTRN	_logregs:PROC
	ENDIF
	; EXTRN	_crashme:PROC
	EXTRN	_outside_vmm:DWORD

Interrupts \
	=	060h

v86_iret_frame STRUCT
	frame_eip DD	?
	frame_cs DD	?
	frame_eflags DD ?
	pm_esp  DD	?
	pm_ss	DD	?
	v86_es	DD	?
	v86_ds	DD	?
	v86_fs	DD	?
	v86_gs	DD	?
v86_iret_frame	ENDS

idt_gate_descriptor STRUCT
	idt_offset_low DW ?
	idt_selector DW	?
	idt_unused DB	?
	idt_flags DB	?
	idt_offset DW	?
idt_gate_descriptor ENDS

jmp_short_skip MACRO intr
	jmp	SHORT skip&intr
	ENDM

jmp_short_link MACRO intr, min, dest
skip&intr:
	IF	(intr - 32) GT min
		jmp_short_skip %(intr-32)
	ELSE
		jmp	SHORT dest
	ENDIF
	ENDM

link	MACRO	intr
interrupt_entry_&intr:
	IF	intr LT 010h
		IRP	ec_fault, <8, 0Ah, 0Bh, 0Ch, 0Dh, 0Eh, -1>
			IF	intr EQ ec_fault
				push	BYTE PTR (intr OR 80h)
				jmp	SHORT ec_fault_handler
				EXITM
			ELSEIF	ec_fault EQ -1
				push	BYTE PTR intr
				jmp	SHORT fault_handler
			ENDIF
		ENDM
	ELSEIF	intr LT 50h
		push	BYTE PTR intr
		jmp_short_link intr, 10h, windows_fault_handler
	ELSE
		push	BYTE PTR intr
		jmp	SHORT vpicd_fault_handler
	ENDIF
	ENDM

idt_entry MACRO	intr
	DD	OFFSET32 interrupt_entry_&intr
	ENDM
	
	VXD_LOCKED_DATA_SEG

	PUBLIC	_v86_restore_jemm_pt_cbfn

_v86_restore_jemm_pt_cbfn \
	DD	?

	VXD_LOCKED_DATA_ENDS

_IDT_DATA SEGMENT DWORD PUBLIC FLAT 'LCODE'

	PUBLIC	_my_idt_vectors
_my_idt_vectors LABEL	BYTE
intnum	=	0
	REPT	Interrupts
		idt_entry %intnum
	intnum	=	intnum + 1
	ENDM

_IDT_DATA ENDS


_IDT_TEXT SEGMENT PARA PUBLIC FLAT 'LCODE'

	ASSUME	ss:FLAT,ds:NOTHING,gs:NOTHING,es:NOTHING,fs:NOTHING

	ALIGN	16

intnum	=	50h
	REPT	3Fh
	intnum	=	intnum - 1
		link	%intnum
	ENDM

interrupt_entry_16:
	push	10h

windows_fault_handler:
	test	BYTE PTR [(esp+1*4).frame_eflags + 2],(VM_MASK SHR 16)
	jz	@@isnt_v86

@@is_v86_fault:
	pushad
	cld
	mov	edi,cr2

	mov	eax,ss
	mov	ds,eax
	mov	es,eax
	mov	fs,eax
	mov	gs,eax

	push	esp
	push	DWORD PTR [esp+8*4+4]
	push	0
	inc	[_outside_vmm]
	call	_handle_idt
	dec	[_outside_vmm]
	add	esp,3*4

	cmp	eax,-2
	je	@@fatal_error

	cmp	eax,-1
	jne	@@chain_to_vmm

@@dont_chain:
	;
	; Restore registers, remove interrupt number and error code 
	; and return to v86 mode
	; 
	xor	eax,eax
	mov	ds,eax
	mov	es,eax
	mov	fs,eax
	mov	gs,eax
	mov	cr2,edi
	popad
	test	BYTE PTR [esp],80h
	jz	@@nocode
	add	esp,4
@@nocode:
	add	esp,4
	
	iretd

	ALIGN	4

@@is_swint:
	add	esp,4	; ignore any prefixes

	movzx	ebx,BYTE PTR ss:[ebp+esi*1]

	inc	ebp
	xchg	[@@frame.frame_eip],ebp

	push	esp
	push	ebx
	push	0
	inc	[_outside_vmm]
	call	_handle_idt
	dec	[_outside_vmm]
	add	esp,3*4

	cmp	eax,-1
	je	@@dont_chain

	cmp	eax,-2
	je	@@fatal_error

	test	eax,eax
	jnz	@@switch_back_on_iret

	mov	[@@frame.frame_eip],ebp
	jmp	@@dont_switch_back_on_iret

	ALIGN	16

interrupt_entry_13:
	push	BYTE PTR (0Dh OR 80h)
	test	BYTE PTR [(esp+2*4).frame_eflags + 2],(VM_MASK SHR 16)
	jz	@@isnt_v86
	
	pushad
	cld
	mov	edi,cr2

	mov	eax,ss
	mov	ds,eax
	mov	es,eax
	mov	fs,eax
	mov	gs,eax

	;
	; Examine the instruction to see what 
	; caused the GPF
	;

	;
	; pattern:	1001110x  
	;
	;  PUSHF	10011100
	;  POPF		10011101
	;
	; pattern:	110011xx
	;
	;  INT3		11001100
	;  INTO		11001101
	;  INT		11001110
	;  IRET		11001111
	;
	; pattern:	x110x1xx
	;
	;  FS:          01100100
	;  GS:		01100101
	;  OPSIZ	01100110
	;  ADRSIZ       01100111
	;  INS		0110110w
	;  OUTS		0110111w
	;  IN imm	1110010w
	;  IN           1110110w
	;  OUT imm      1110011w
	;  OUT          1110111w
	;
	; pattern:	1111x01x
	;
	;  REPNE	11110010
	;  REPE         11110011
	;  CLI		11111010
	;  STI		11111011
	;

@@frame	EQU	<(esp+8*4+2*4)>
	movzx	esi,WORD PTR [@@frame.frame_cs]
	movzx	ebp,WORD PTR [@@frame.frame_eip]
	shl	esi,4

	;
	; Store prefixes in the following locations,
	; if found:
	;
	;	[esp]:   OPSIZ
	;	[esp+1]: ADRSIZ
	;	[esp+2]: REPE REPNE
	;	[esp+3]: CS: DS: ES: SS: FS: GS: 
	;

	push	0

@@next:
	movsx	eax, BYTE PTR ss:[ebp+esi*1]

BYTE_SIGNX EQU <0FFFFFF00h OR>
	;
	; Check it see if it's an interrupt (INT3, INTO, INT)
	; or IRET instruction.  Treat the single byte interrupts,
	; INT3 and INTO as I/O instructions for know.
	; 
	mov	edx,eax
	inc	bp
	jz	@@isnt_swint
	and	edx,BYTE_SIGNX 11111100b
	cmp	edx,BYTE_SIGNX 11001100b
	jne	@@isnt_int_or_iret
	cmp	eax,BYTE_SIGNX 0CDh		; INT imm
	je	@@is_swint
	jmp	@@no_operand_opcode

@@isnt_int_or_iret:
	;
	; Check to see if it's a PUSHF or POPF instruction
	; Check to see if it's a REP prefix or a CLI/STI instruction
	; Check to see if it has the bit pattern of one of the
	; original '86 segment override prefixes (CS: DS: ES: SS:)
	;
	mov	ebx,eax
	mov	ecx,eax
	and	ebx,BYTE_SIGNX 11111110b
	mov	edx,eax
	and	ecx,BYTE_SIGNX 11110110b
	cmp	ebx,BYTE_SIGNX 10011100b
	je	@@no_operand_opcode	; is PUSHF or POPF
	and	edx,BYTE_SIGNX 11100111b
	cmp	ecx,BYTE_SIGNX 11110010b
	je	@@is_rep_or_clisti
	cmp	edx,00100110b	
	je	@@is_seg_prefix		

@@not_rep:
	;
	; Check to see if it has the bit pattern of one of the 
	; I/O opcodes (IN, INS, OUT, OUTS) or one of the '386
	; prefixes (OPSIZ, ADRSIZ, FS:, GS:)
	;
	mov	edx,eax
	and	edx,01110100b		
	cmp	edx,01100100b		
	jne	@@isnt_swint	; not any interesting opcode 
	;
	; Check to see if the it's an I/O opcode or a '386 prefix
	;
	test	al,10001000b	
	jnz	@@is_io_opcode

	test	al,00000010b
	jz	@@is_seg_prefix

	;
	; Either OPSIZ or ADRSIZ
	;
	cmp	al,66h		; less jumps is good
	setne	dl		; (al EQ 66h, al NE 66h) -> (0, 1)
	sete	cl
	dec	dl		; (0, 1) -> (FF, 0) 
	dec	cl
	and	dl,66h		; (FF, 0) -> (66h, 0) 
	and	cl,67h
	or	BYTE PTR [esp],dl
	or	BYTE PTR [esp+1],cl
	jmp	@@next

@@isnt_swint:
	mov	[esp],esp
	push	1
	jmp	@@handle_gpf
	
	;
	; Check to see if the byte is a CLI/STI instruction
	; or a REPNE/REPE prefix.
	;
@@is_rep_or_clisti:
	test	al,00001000b
	jnz	@@no_operand_opcode	; is CLI or STI
	; is REPNE or REPE
	mov	BYTE PTR [esp+2],al
	jmp	@@next

@@is_seg_prefix:
	mov	BYTE PTR [esp+3],al	
	jmp	@@next	

	;
	; Pack the full instruction into edx:eax, padding at
	; at the end with NOPs
	;

@@is_io_opcode:
	test	al,00001000b
	jne	@@no_operand_opcode
	movzx	eax,al
	or	eax,90900000h
	mov	ah,BYTE PTR ss:[ebp+esi*1]
	inc	bp
	jmp	@@form_instruction

@@no_operand_opcode:
	movzx	eax,al
	or	eax,90909000h

@@form_instruction:
	pop	ecx

	push	esp	; frame
	push	eax	; opcode
	push	ebp	; EIP after instruction

	mov	edx,00009090h

	test	ecx,ecx
	jnz	@@prefixes

@@call_handler:
	push	edx	; instruction: bytes 4-5
	push	eax	; instruction: bytes 0-3
	push	2
	inc	[_outside_vmm]
	call	_handle_idt
	dec	[_outside_vmm]
	add	esp,6*4

	test	eax,eax
	jz	@@dont_switch_back_on_iret

	cmp	eax,-2
	je	@@fatal_error

	cmp	eax,-1
	jne	@@switch_back_on_iret

	jmp	@@dont_chain

@@prefixes:
@@ecx_not_zero:
	test	cl,cl
	jz	@@next_byte
	shld	edx,eax,8
	shl	eax,8
	mov	al,cl
@@next_byte:
	shr	ecx,8
	jnz	@@ecx_not_zero
	jmp	@@call_handler

	ALIGN	4

intnum	=	60h
	REPT	0Fh
	intnum	=	intnum - 1
		link	%intnum
	ENDM

interrupt_entry_80:
	push	50h

vpicd_fault_handler:

	IF 0

	pushad
	push	ds
	push	es
	mov	eax,DWORD PTR [esp+8*4+2*4]
	sub	eax,50h
	mov	ebx,ss
	mov	ds,ebx
	mov	es,ebx
	push	eax
	push	OFFSET32 @@hwint_msg
	inc	[_outside_vmm]
	call	_lognum
	dec	[_outside_vmm]
	add	esp,2*4
	pop	es
	pop	ds
	popad

	ENDIF
	
	test	BYTE PTR [(esp+1*4).frame_eflags + 2],(VM_MASK SHR 16)
	jz	@@isnt_v86

	pushad
	cld
	mov	edi,cr2
	
	push	esp
	push	3

@@handle_fault:
	mov	eax,ss
	mov	ds,eax
	mov	es,eax
	mov	fs,eax
	mov	gs,eax

	ASSUME	ds:FLAT,es:FLAT

@@handle_gpf:
	inc	[_outside_vmm]
	call	_handle_idt
	dec	[_outside_vmm]
	add	esp,2*4

	cmp	eax,-2
	je	@@fatal_error

@@chain_to_vmm:
	test	eax,eax
	jz	@@dont_switch_back_on_iret

@@switch_back_on_iret:
	mov	ebx,eax

	;
	; Calculate the address of the interrupt frame
	;
	movzx	eax,BYTE PTR [esp + 8*4]	; interrupt number
	shr	eax,7				; extract err code flag
	lea	ebp,[esp + 8*4 + 4 + eax*4]

	;
	; Copy return address to V86 stack and have the VMM handler
	; return to the restore callback function 
	;
	sub	WORD PTR [ebp.pm_esp],4
	movzx	eax,WORD PTR [ebp.pm_ss]
	movzx	ecx,WORD PTR [ebp.pm_esp]
	shl	eax,4
	mov	edx,DWORD PTR [ebp.frame_eip]
	add	eax,ecx
	mov	esi,DWORD PTR [ebp.frame_cs]
	mov	WORD PTR [eax],dx
	mov	WORD PTR [eax+2],si

	movzx	ecx,bx
	shr	ebx,16
	mov	DWORD PTR [ebp.frame_eip],ecx
	mov	WORD PTR [ebp.frame_cs],bx

@@dont_switch_back_on_iret:

	ASSUME	ds:NOTHING,es:NOTHING

	mov	cr2,edi
	popad

@@isnt_v86:
	xchg	ebp,DWORD PTR [esp]		; get interrupt num
	push	eax
	push	edx
	mov	edx,cr2
	push	edx
	;
	; Get the offset of the VMM handler from the VMM's IDT
	; and "return" to it.
	;
	mov	eax,ebp
	and	ebp,7Fh
	shr	eax,7
	and	eax,1
	lea	ebp,[_saved_vmm_idt+ebp*8]
	mov	edx,DWORD PTR [(esp + eax*4 + 4*4).frame_eflags]

	cmp	BYTE PTR [ebp.idt_flags],85h	; task gate
	je	@@task_gate

@@back:
	and	edx,NOT (VM_MASK OR NT_MASK OR RF_MASK OR TF_MASK)

	mov	eax,DWORD PTR [ebp.idt_unused]	; get high part of offset
	mov	ax,WORD PTR [ebp.idt_offset_low]

	test	BYTE PTR [ebp.idt_flags],1	; check gate type

	mov	bp,WORD PTR [ebp.idt_selector]	; get selector

	jnz	@@trap_gate
	and	edx,NOT IF_MASK			; clear intr flag
@@trap_gate:

	;
	; Restore eax, ebp, edx and put the VMM handler's address 
	; on the stack.
 	;
	xchg	ebp,[esp]
	mov	cr2,ebp
	pop	ebp

	xchg	edx,[esp]
	xchg	eax,[esp+4]
	xchg	ebp,[esp+8]

	popfd
	retf

	ALIGN	4

intnum	=	10h
	REPT	intnum-1
	intnum	=	intnum - 1
		IF	(intnum NE 0Dh) AND (intnum NE 02h)
			link	%intnum
		ENDIF
	ENDM

interrupt_entry_0:
	push	0

fault_handler:
	test	BYTE PTR [(esp+1*4).frame_eflags + 2],(VM_MASK SHR 16)
	jnz	@@is_v86_fault
	jmp	@@isnt_v86
	
ec_fault_handler:
	test	BYTE PTR [(esp+2*4).frame_eflags + 2],(VM_MASK SHR 16)
	jz	@@logfault

	pushad
	cld
	mov	edi,cr2
	
	ASSUME	ds:FLAT,es:FLAT

	push	esp
	push	1
	jmp	@@handle_fault

@@logfault:
	pushad
	cld
	mov	edi,cr2
	mov	ebp,esp
	push	ds
	push	es
	push	fs
	push	gs
	mov	eax,ss
	mov	ds,eax
	mov	es,eax
	mov	fs,eax
	mov	gs,eax

	push	ebp
	push	0FFFFFF80h
	IFDEF	USE_LOG
	inc	[_outside_vmm]
	call	_logregs
	dec	[_outside_vmm]
	ENDIF
	add	esp,2*4

	push	edi
	push	OFFSET32 @@text2
	IFDEF	USE_LOG
	inc	[_outside_vmm]
	call	_lognum
	dec	[_outside_vmm]
	ENDIF
	add	esp,2*4

	IF 	0

	movzx	eax,BYTE PTR [ebp+8*4]
	shr	eax,7
	mov	esi,[(ebp+8*4+4+eax*4).frame_eip]
	VxDCall	_GetVxDName, <esi, OFFSET32 @@buf>
	push	OFFSET32 @@buf
	inc	[_outside_vmm]
	call	_lognote
	dec	[_outside_vmm]
	add	esp,4
	push	OFFSET32 @@buf+12
	inc	[_outside_vmm]
	call	_lognote
	dec	[_outside_vmm]
	add	esp,4

	ENDIF

	pop	gs
	pop	fs
	pop	es
	pop	ds
	
	mov	cr2,edi
	popad
	jmp	@@isnt_v86

@@fatal_error:

	; VxDCall	Crash_Cur_VM

	add	esp,8*4			; remove popad regs
	pop	eax			; int number
	cmp	al,80h
	jb	@@no_code
	pop	eax
@@no_code:
	push	1			; new error code
	push	88h			; double fault
	jmp	@@isnt_v86

	VXD_LOCKED_DATA_SEG

@@text:
	DB	'nonv86 fault', 0

@@text2:
	DB	'cr2', 0

@@text3:
	DB	'eip', 0

@@buf	DB	80 dup (?)

	VXD_LOCKED_DATA_ENDS

interrupt_entry_2:
	jmp	NEAR PTR @@nextinsn
@@nextinsn:
	nop
	nop
	nop
	inc	[_nmi_counter]
	iretd

	VXD_LOCKED_DATA_SEG

	PUBLIC	_nmi_counter
_nmi_counter \
	DD	0

	VXD_LOCKED_DATA_ENDS

	PUBLIC	_nmi_handler
_nmi_handler PROC

	inc	[_nmi_counter2]
	push	eax
	in	al,61h
	test	al,80h
	jz	@@not_pci_serr

	and	al,3
	or	al,0Ch
	out	61h,al
	and	al,3
	out	61h,al

@@not_pci_serr:
	pop	eax

	; ret

	jmp	[_old_nmi_handler]

	VXD_LOCKED_DATA_SEG

	PUBLIC	_old_nmi_handler
_old_nmi_handler \
	DD	0

	PUBLIC	_nmi_counter2
_nmi_counter2 \
	DD	0

	VXD_LOCKED_DATA_ENDS

_nmi_handler ENDP


@@bad_gate:
@@task_gate:
	cld
	mov	eax,ss
	mov	ds,eax
	mov	es,eax
	VxDCall	Crash_Cur_VM

	mov	al,01
	out	0Ah,al
	mov	al,00
	out	0Ch,al

_IDT_TEXT ENDS

	VXD_LOCKED_DATA_SEG
	
@@hwint_msg \
	DB	'hwint', 0

	VXD_LOCKED_DATA_ENDS

	END

	; Local Variables:
	; mode:fundamental
	; End:
