
; myvjemm.asm
;
; By Ross Ridge
; Public Domain
;
; Command line interface for loading the VJEMM VXD and
; then main Privateer executable.
;

	IDEAL

	LOCALS
	JUMPS
	SMART

	INCLUDE	"vjemmapi.ash"
	INCLUDE	"vernums.ash"

	P386N

DEFAULT_COMMAND 	EQU	<"PRCD.EXE">
DISK_PRIV_COMMAND	EQU	<"PRIVATER.EXE">
DISK_RF_COMMAND		EQU	<"PRSO.EXE">

	SEGMENT	text PARA PUBLIC USE16
	ENDS
	SEGMENT data WORD PUBLIC USE16
	ENDS
	SEGMENT bss WORD PUBLIC USE16
	ENDS
	SEGMENT stackseg WORD STACK USE16
	DW	512 DUP (?)
	ENDS
	SEGMENT itext PARA PUBLIC USE16
	ENDS
	SEGMENT idata WORD PUBLIC USE16
	ENDS
	SEGMENT ibss WORD PUBLIC USE16
	ENDS

	GROUP	progseg text, data, bss, itext, idata, ibss

	ASSUME	CS:progseg
	ASSUME	DS:progseg
	ASSUME	SS:stackseg
	ASSUME	ES:NOTHING
	ASSUME	FS:NOTHING
	ASSUME	GS:NOTHING

	SEGMENT data
	DB	"@(#) vjemm myvjemm.asm 1.5 03/06/09 18:48:14"
	ENDS

PAGE_SIZE \
	=	4096

CR	=	13
LF	=	10
CRLF	EQU	<CR, LF>

	MACRO	DEBUG_MSG msg
	LOCAL	msgstr
		SEGMENT	data
		msgstr:
			DB	msg, CRLF, '$'
		ENDS

		pushf
		pusha
		push	ds
		mov	dx,OFFSET msgstr
		mov	ax,SEG msgstr
		mov	ds,ax
		mov	ah,09h
		int	21h
		pop	ds
		popa
		popf
	ENDM

	MACRO	DEBUG_STR addr
	LOCAL	loop, ctrl, done
		pushf
		pusha
		push	ds
		mov	ah,2
		lds	si,[addr]
	loop:
		lodsb
		cmp	al,0
		je	done
		mov	dl,'.'
		cmp	al,32
		jb	ctrl
		mov	dl,al
	ctrl:
		int	21h
		jmp	loop
	done:
		mov	dl,0Dh
		int	21h
		mov	dl,0Ah
		int	21h
		pop	ds
		popa
		popf
	ENDM

VXDLDR_DEVICE_ID		=	27h
VXDLDR_APIFUNC_GETVERSION	=	0
VXDLDR_APIFUNC_LOADDEVICE	=	1
VXDLDR_APIFUNC_UNLOADDEVICE	=	2

	SEGMENT	text

_using_jemm_pt \
	DD	?

	DB	6 DUP (90h)
_restore_jemm_pt_cbfn:
	INT	3
	DB	20 DUP (63h)
	push	ax
	push	bx
	mov	ax,1209h
	mov	bx,1234h
	int	15h
	pop	bx
	pop	ax
	retf	2

	;
	;
	;

	PROC	run_priv

	mov	ax,1209h
	mov	bx,736dh
	int	15h

	push	ds
	push	ds
	pop	es
	mov	bx,OFFSET @@parameter_block
	lds	dx,[command]
	mov	ax,4B00h	; DOS EXEC
	int	21h
	pop	ds
	mov	al,'5'
	jc	@@fail

	mov	ax,1209h
	mov	bx,736dh
	int	15h

	mov	ah,4Dh		; get return code
	int	21h

@@fail:
	ret

	SEGMENT	data

@@fcb:
	DB	0		; drive
	DB	8 DUP (' '), 3 DUP (' ')
	DW	0		; block
	DW	0		; record size
	DD	0		; size
	DW	0		; date
	DW	0		; time
	DB	8 DUP (?)	; reserved
	DB	0		; record
	DD	0		; random access
	
@@parameter_block:
	DW	0h		; enviroment
cmdarg	DD	default_arg
	DD	@@fcb		; FCB1
	DD	@@fcb		; FCB2
	DD	?
	DD	?

	ENDS

	ENDP	run_priv

	;
	;
	;

	PROC	run_strike

	SEGMENT	data

opttest_cmd \
	DB	"OPTTEST.EXE", 0
@@strike_cmd \
	DB	"STRIKE.EXE", 0
@@mkterr_cmd \
	DB	"MKTERR.EXE", 0

	IF	0
@@opttest_arg_first \
	DB	"Nubert -v -r", CR
@@mkterr_arg \
	DB	"Nubert 000", CR
@@strike_arg \
	DB	"Nubert -v -g", CR
@@opttest_arg \
	DB	"Nubert -v -.m", CR
	ENDIF	

@@nubert_arg \	
	DB	@@opttest_arg_first_len
	DB	"Nubert -v -"
@@nubert_opt \
	DB	"g", CR, CR

@@opt_offset \
	=	@@nubert_opt - @@nubert_arg

@@opttest_arg_first_len \
	= 	@@opt_offset + 1
@@opttest_arg_len \
	= 	@@opt_offset + 2
@@strike_arg_len \
	=	@@opt_offset + 1
@@mkterr_arg_len \
	=	@@opt_offset - 1

	ENDS	data

	mov	si, OFFSET @@nubert_arg
	mov	[WORD LOW cmdarg], si
	mov	[WORD HIGH cmdarg],cs
	mov	di, OFFSET command
	mov	[WORD PTR di + 2],cs

@@run_opttest:
	mov	[WORD PTR di], OFFSET opttest_cmd
	call	run_priv
	jc	@@ret
	cmp	al,1
	jb	@@run_strike
	je	@@done

 	aam 	100
	add	ah,30h
	mov	[BYTE PTR si + @@opt_offset - 4],ah
	aam
	add	ax,3030h
	xchg	al,ah
	mov	[WORD PTR si + @@opt_offset - 3],ax
	mov	[BYTE PTR si + @@opt_offset - 1],CR
	mov	[BYTE PTR si], @@mkterr_arg_len

	mov	[WORD PTR di], OFFSET @@mkterr_cmd
	call	run_priv
	jc	@@ret
	cmp	al,1
	je	@@done

	mov	[DWORD PTR si + @@opt_offset - 4], "- v-"

@@run_strike:
	mov	[WORD PTR si + @@opt_offset],  'g' OR (CR SHL 8)
	mov	[BYTE PTR si], @@strike_arg_len

	mov	[WORD PTR di], OFFSET @@strike_cmd
	call	run_priv
	jc	@@ret
	cmp	al,1
	mov	[BYTE PTR si], @@opttest_arg_len
	mov	[WORD PTR si + @@opt_offset], "m."
	jne	@@run_opttest

@@done:
	mov	al,0

@@ret:
	ret

	ENDP

	SEGMENT	idata

init	init_packet { using_jemm_pt_ptr = _using_jemm_pt, \
		      restore_jemm_pt_cbfn = _restore_jemm_pt_cbfn, \
		      dma_buffer = 0, \
		      sblive_fix = 0 } 

	ENDS

	SEGMENT	data

default_cmd \
	DB	DEFAULT_COMMAND
default_arg:
	DB	0, 0Dh

disk_priv_cmd \
	DB	DISK_PRIV_COMMAND, 0

disk_rf_cmd \
	DB	DISK_RF_COMMAND, 0

command	DD	default_cmd

run_proc \
	DW	OFFSET run_priv

	ENDS

	SEGMENT	bss

vxdldr_api \
	DD	?
vjemm_api \
	DD	?

	ENDS

	;
	;
	;

	PROC	go_jemm

	mov	bx, OFFSET init
	mov	cx, ds
	mov	ax, VJEMM_FORCE_JEMM_PT
	call	[vjemm_api]
	mov	dl,'3'
	jc	@@ret
	or	eax,eax
	jnz	@@ret

	call	[run_proc]
	jc	@@failed
	mov	al,0
@@failed:
	xchg	ax,dx

	mov	ax,VJEMM_RESTORE_PT
	call	[vjemm_api]
	jnc	@@ret
	mov	dl,'4'

@@ret:
	ret

	ENDP

	;
	;
	;

	SEGMENT	data

loaded_vxd \
	DB	0

banner \
	DB	CRLF
	DB	"MyJEMM Version "
%	DB	"&VJEMM_VERSION_MAJOR.&VJEMM_VERSION_MINOR"
%	DB	".&VJEMM_VERSION_BUILD", CRLF
	DB	"By Ross Ridge, Public Domain", CRLF, "$"

	ENDS

	;
	;
	;

	PROC	start2

	SEGMENT	data

@@exec_fail_msg \
	DB	": can't run program", CRLF, "$"

@@cant_unload_msg \
	DB	"Can't unload vjemm.vxd", CRLF, "$"

@@error_code_msg \
	DB	"Error Code: 0", CRLF, "$"

@@error_code_offset \
	=	12

@@vjemm_module_name \
	DB	VJEMM_MODULE_NAME, 0
	
	ENDS

	call	go_jemm

unload:
	push	dx

	cmp	[loaded_vxd],0
	je	@@wasnt_loaded

	mov	bx,-1
	mov	dx,OFFSET @@vjemm_module_name
	mov	ax,VXDLDR_APIFUNC_UNLOADDEVICE
	call	[vxdldr_api]
	mov	dx,OFFSET @@cant_unload_msg
	jc	@@fail_msg
	
@@wasnt_loaded:
	pop	ax
	cmp	al,'5'
	je	@@exec_fail
	cmp	al,0
	je	@@success

@@error_code:
	mov	[@@error_code_msg + @@error_code_offset],al
	mov	dx,OFFSET @@error_code_msg

@@fail_msg:	
	mov	ah,09h
	int	21h

@@success:
	mov	dx,OFFSET banner
	mov	ah,09h
	int	21h

	mov	ah,4Ch
	int	21h
	ret

@@exec_fail:
	les	si,[command]
@@loop_exec_fail:
	lods	[BYTE PTR es:si]
	cmp	al,0
	mov	dx, OFFSET @@exec_fail_msg
	jz	@@fail_msg
	mov	dl,al
	mov	ah,02h
	int	21h
	jmp	@@loop_exec_fail

	ENDP

	ENDS	text

	 ;
	 ;
	 ;

	SEGMENT	itext

	P8086

	PROC	get_api

	mov	ax,1600h
	int	2Fh
	cmp	al,0
	je	@@fail
	cmp	al,80h
	je	@@fail
	mov	ax,1684h
	int	2Fh
	mov	ax,es
	mov	[si],di
	mov	[si+2],ax
	or	ax,di
	jnz	@@ret
@@fail:
	stc
@@ret:
	ret

	ENDP

	;
	;
	;

	PROC	get_vxdldr_api

	mov	bx,VXDLDR_DEVICE_ID
	xor	di,di
	mov	si, OFFSET vxdldr_api
	jmp	get_api

	ENDP

	P386

	;
	;
	;

	PROC	get_vjemm_api

	SEGMENT	idata

@@vjemmvxdname \
	DB	VJEMM_MODULE_NAME_PADDED, 0

	ENDS

	xor	bx,bx
	push	ds
	pop	es
	mov	di,OFFSET @@vjemmvxdname
	mov	si,OFFSET vjemm_api
	jmp	get_api

	ENDP

	;
	;
	;

	PROC	start

	SEGMENT	idata

@@vjemm_file \
	DB	"vjemm.vxd", 0

@@force_unload \
	DB	0

@@ems_fail_msg \
	DB	"EMS memory requried", CRLF
	DB	CRLF
	DB	\
"If you're using Windows 95 or 98, try adding the following line to your"
	DB	CRLF
	DB	"CONFIG.SYS file and reboot:", CRLF
	DB	CRLF
	DB	"DEVICE=C:\WINDOWS\EMM386.EXE RAM", CRLF
	DB	CRLF
	DB	\
"If you're using Windows ME, then please see Microsoft Knowledge Base"
	DB	CRLF
	DB	"article Q275423.", CRLF
	DB	CRLF, "$"

@@not_win9x_msg \
	DB	"Windows 95/98/ME required", CRLF, "$"

@@cant_load_msg \
	DB	"Can't load vjemm.vxd", CRLF, "$"

@@usage_msg \
	DB	"usage: MYJEMM [-u] [-s] [prog [args]]", CRLF
	DB	CRLF
	DB	"To play WC: Privateer:           myjemm", CRLF
	DB	"To play Righteous Fire:          myjemm r", CRLF
	DB	"To play WC: Armada (disk):       myjemm armada.exe", CRLF
	DB	"To play WC: Armada (CD):         myjemm armadacd.exe", CRLF
	DB	"To play Proving Grounds (disk):  myjemm pg.exe", CRLF
	DB	"To play Proving Grounds (CD):    myjemm pgcd.exe", CRLF
	DB	"To play Strike Commander (disk): myjemm s", CRLF, "$"

@@access_failed_msg \
	DB	": can't find program", CRLF, CRLF, "$"

@@resize_failed_msg \
	DB	"Out of memory", CRLF, "$"

@@disk_cmd \
	DW	OFFSET disk_priv_cmd

	ENDS	idata
	
	P8086 

	cld

	push	ds
	push	cs
	pop	ds

 	call	get_vxdldr_api
	mov	dx,OFFSET @@not_win9x_msg
	jc	@@fail_msg

	pop	ds	

	P386

	ASSUME	ds:NOTHING

	mov	si,80h
	movzx	cx,[BYTE PTR si]
	inc	si

	jcxz	@@done_tail2

@@loop_tail:
	lodsb
@@parse_char:
	cmp	al,' '
	je	@@next
	cmp	al,'-'
	je	@@switch
	cmp	al,'/'
	jne	@@not_switch

@@switch:
	dec	cx
	jz	@@usage
	lodsb

	cmp	al,'u'
	jne	@@not_u
	inc	[@@force_unload]
	inc	[loaded_vxd]
@@done_tail2:
	jmp	@@done_tail
@@not_u:

	cmp	al,'s'
	jne	@@usage
	inc	[init.sblive_fix]

@@next:
	loop	@@loop_tail
	jmp	@@done_tail

@@not_switch:
	cmp	cx,1
	jne	@@not_1char
	cmp	al,'r'
	je	@@is_r
	cmp	al,'s'
	je	@@is_s

@@not_1char:
	lea	di,[si-2]
	mov	[WORD LOW command],di
	mov	[WORD HIGH command],ds
	mov	[di],al

@@loop_arg:
	loop	@@next_arg

	mov	[BYTE PTR si-1],ch
	jmp	@@done_tail

@@next_arg:
 	lodsb
	mov	[si-2],al
	cmp	al,' '
	jne	@@loop_arg
	mov	[BYTE PTR si-2],ch

@@loop_space:
	lodsb
	cmp	al,' '
	loope	@@loop_space
	jmp	@@args

@@usage:
	mov	dx,OFFSET @@usage_msg
	push	cs
	pop	ds
	jmp	@@fail_msg

@@is_s:
	mov	[run_proc], OFFSET run_strike
	mov	[WORD PTR command], OFFSET opttest_cmd
	jmp	@@done_tail

@@is_r:
	mov	[@@disk_cmd], OFFSET disk_rf_cmd

@@args:
	dec	si
	dec	si
	mov	[WORD LOW cmdarg],si
	mov	[WORD HIGH cmdarg],ds
	mov	[si],cl

@@done_tail:
	;DEBUG_STR command
	;DEBUG_STR cmdarg

	mov	si,ds		; PSP seg
	mov	es,si
	push	cs
	pop	ds

	ASSUME	ds:progseg

	xor	dx,dx
	cmp	[@@force_unload],dl
	jnz	unload

	mov	bx,ss
	add	bx, (SIZE stackseg + PAGE_SIZE * 3 - 1) / 16
	MASKFLAG bx,NOT (PAGE_SIZE / 16 - 1)
	lea	ax,[bx - PAGE_SIZE * 2 / 16]
	sub	bx,si
	mov	[WORD HIGH init.dma_buffer], ax
	
	mov	ah,4Ah
	int	21h
	mov	dx,OFFSET @@resize_failed_msg
	jc	@@fail_msg

	mov	ah,EMS_GET_PAGE_FRAME
	int	67h
	mov	dx,OFFSET @@ems_fail_msg
	cmp	ah,0
	jne	@@fail_msg

	mov	[init.ems_page_frame], bx

	cmp	[WORD HIGH command],progseg
	jnz	@@not_default

	mov	dx,[@@disk_cmd]
	mov	ax,4300h
	int	21h
	jc	@@use_default
	mov	[WORD LOW command],dx
	mov	[WORD LOW cmdarg], OFFSET default_arg
	mov	[WORD HIGH cmdarg], SEG default_arg

@@use_default:
@@not_default:
	push	ds
	lds	dx,[command]
	mov	ax,4300h
	int	21h
	jc	@@not_found
	pop	ds

	call	get_vjemm_api
	jnc	start2

	mov	dx,OFFSET @@vjemm_file
	mov	ax,VXDLDR_APIFUNC_LOADDEVICE
	call	[vxdldr_api]
	mov	dx,OFFSET @@cant_load_msg
	jc	@@fail_msg

	inc	[loaded_vxd]

	call	get_vjemm_api
	mov	dl,'6'
	jc	unload
	jmp	start2

	P8086

@@fail_msg:	
	mov	ah,09h
	int	21h

	mov	dx,OFFSET banner
	mov	ah,09h
	int	21h

	mov	ax,4C00h
	int	21h
	ret

@@not_found:
	mov	si,dx
@@loop_prog:
	lodsb
	cmp	al,0
	je	@@done_prog
	xchg	ax,dx
	mov	ah,02h
	int	21h
	jmp	@@loop_prog
	
@@done_prog:
	pop	ds
	mov	dx,OFFSET @@access_failed_msg
	mov	ah,09h
	int	21h
	mov	dx,OFFSET @@usage_msg
	jmp	@@fail_msg
	
	ENDP

	ENDS	itext

	END	start
